

<?php $__env->startSection('title'); ?> Mes dossiers <?php $__env->stopSection(); ?>

<?php $__env->startSection('CSS'); ?> 


<link rel="stylesheet" type="text/css" href="<?php echo e(url('/')); ?>/js/datatables/dataTables.bootstrap4.min.css">

<style type="text/css">
.figure-attachment {
    min-height: 100px;
}
.fa-lg {
  font-size: 36px !important;
}


</style>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('JS'); ?> 


<script src="<?php echo e(url('/')); ?>/js/datatables/jquery.dataTables.min.js"></script>
<script src="<?php echo e(url('/')); ?>/js/datatables/dataTables.bootstrap4.min.js"></script>

<script type="text/javascript" class="init">
  $(document).ready(function() {
    $("#example").dataTable({ "language": { "url": "<?php echo e(url('/')); ?>/js/datatables/lang/fr.json" }
    });
  });
  </script>

<?php $__env->stopSection(); ?>


<?php $__env->startSection('content'); ?>
                  
                  <!-- ============================================================== -->
                  <!-- pageheader  -->
                  <!-- ============================================================== -->
                  <div class="row">
                      <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                          <div class="page-header">
                              <h3 class="mb-2">Mes dossiers </h3>
                           
                              <div class="page-breadcrumb">
                                  <nav aria-label="breadcrumb">
                                      <ol class="breadcrumb">
                                          <li class="breadcrumb-item"><a href="<?php echo e(URL::route('enseignant_index')); ?>" class="breadcrumb-link">Accueil</a></li>
                                          <li class="breadcrumb-item active" aria-current="page">Mes dossiers</li>
                                      </ol>
                                  </nav>
                              </div>
                          </div>
                      </div>
                  </div>
                  <!-- ============================================================== -->
                  <!-- end pageheader  -->
                  <!-- ============================================================== -->


<div class="row">


<div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
  <div class="card">
    <h5 class="card-header">
      <a href="#" class="btn btn-primary mb-1" data-toggle="modal" data-target="#exampleModal"><i class="fa fa-folder"></i> Nouveau dossier </a>
    </h5>
  <div class="card-body">

<!-- Modal -->
<div class="modal fade" id="exampleModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
<div class="modal-dialog modal-lg" role="document">
  <div class="modal-content">
    <div class="modal-header">
      <h5 class="modal-title" id="exampleModalLabel">Nouveau dossier</h5>
      <a href="#" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></a>
    </div>
    <div class="modal-body">

<form method="POST" action="<?php echo e(URL::route('folders_store')); ?>">

<?php echo e(csrf_field()); ?>



  <div class="col-md-12 mb-3">
    <div class="form-group">
    <label>Nouveau dossier:</label>
    <input name="folder_name" type="text" class="form-control input-lg" value="<?php echo e(old('folder_name')); ?>" required>
    </div>
  </div>

<div class="col-md-12 mb-4">
      <label>Classes - Matières</label>
      <select name="class_id" class="selectpicker" data-width="100%" required="required">   
      <option value="">Choisir</option>
        <?php $__currentLoopData = $subjects; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $subject): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
          <option value="<?php echo e($subject->cl_id); ?>"><?php echo e($subject->cl_name); ?> - <?php echo e($subject->sbj_name); ?></option>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
      </select>
</div>


<div class="col-md-12">
    <button class="btn btn-success btn-block input-lg" type="submit">Ajouter</button>
</div>


</form>

    </div>
    <div class="modal-footer">
      <a href="#" class="btn btn-dark" data-dismiss="modal">Fermer</a>
    </div>
  </div>
</div>
</div>
<!-- End Modal -->


<div class="clearfix"></div>

<?php if(Session::has('error')): ?>

<div class="alert alert-danger alert-dismissible fade show text-center" role="alert">
  <strong><?php echo e(Session::get('error')); ?></strong>
  <button type="button" class="close" data-dismiss="alert" aria-label="Close">
    <span aria-hidden="true">&times;</span>
  </button>
</div>

<?php endif; ?>

<?php if(Session::has('success')): ?>
<div class="alert alert-success alert-dismissible fade show text-center" role="alert">
  <strong><?php echo e(Session::get('success')); ?></strong>
  <button type="button" class="close" data-dismiss="alert" aria-label="Close">
    <span aria-hidden="true">&times;</span>
  </button>
</div>
<?php endif; ?>

<div class="clearfix"></div>

<div class="row">
<?php $__currentLoopData = $folders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $folder): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

<div class="col-xl-4 col-lg-6 col-md-6 col-sm-12 col-12">
  <div class="card card-figure">

<a href="<?php echo e(URL::route('folder_files', $folder->id)); ?>">
      <figure class="figure">
        <div class="figure-attachment">
          <span class="fa-stack fa-lg">
            <i class="fa fa-square fa-stack-2x text-primary"></i>
            <i class="fa fa-folder fa-stack-1x fa-inverse"></i>
          </span>
        </div>
        <figcaption class="figure-caption">
          <ul class="list-inline d-flex text-muted mb-0">
            <li class="list-inline-item text-truncate mr-auto">
              <?php echo e(html_entity_decode($folder->folder_name)); ?>

              <p class="text-muted"><i class="fa fa-file"></i> <small><strong><?php echo e(count(App\EnseignantsFiles::where('folder_id', $folder->id)->get())); ?></strong> ressources</small>

              <?php $GetClass = \App\Classes::find($folder->class_id); ?> 
              <?php if($GetClass !== null): ?> <i class="fa fa-table"></i> <small><strong><?php echo e($GetClass->name); ?></strong></small> <?php endif; ?>

              </p>
              <a href="#" data-toggle="modal" data-target="#exampleModal-<?php echo e($folder->id); ?>" class="btn btn-outline-primary btn-xs"><i class="fa fa-edit"></i> Modifier</a>
            </li>
          </ul>
        </figcaption>
      </figure>
</a>

    </div>
  </div>        



<!-- Modal -->
<div class="modal fade" id="exampleModal-<?php echo e($folder->id); ?>" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel-<?php echo e($folder->id); ?>" aria-hidden="true">
<div class="modal-dialog" role="document">
  <div class="modal-content">
    <div class="modal-header">
      <h5 class="modal-title" id="exampleModalLabel-<?php echo e($folder->id); ?>">Renommer</h5>
      <a href="#" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></a>
    </div>
    <div class="modal-body">

<form method="POST" action="<?php echo e(URL::route('folder_update', $folder->id)); ?>">

<?php echo e(csrf_field()); ?>



  <div class="col-md-12">
    <div class="form-group">
    <label>Nom de dossier:</label>
    <input name="folder_name_up" type="text" class="form-control input-lg" value="<?php echo html_entity_decode($folder->folder_name); ?>" required>
    </div>
  </div>


<div class="col-md-12 mb-4">
      <label>Classes - Matières</label>
      <select name="class_id_up" class="selectpicker" data-width="100%" required="required"> 

<?php if($GetClass !== null): ?> 
<option value="<?php echo e($GetClass->id); ?>"><?php echo e($GetClass->name); ?></option>
<?php else: ?>
<option value="">Choisir</option>
<?php endif; ?> 
      
        <?php $__currentLoopData = $subjects; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $subject): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
          <option value="<?php echo e($subject->cl_id); ?>"><?php echo e($subject->cl_name); ?> - <?php echo e($subject->sbj_name); ?></option>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
      </select>
</div>


<div class="clearfix"></div><br>

<div class="col-md-12">
    <button class="btn btn-success btn-block input-lg" type="submit">Renommer</button>
</div>


</form>

    </div>
    <div class="modal-footer">
      <a href="#" class="btn btn-dark" data-dismiss="modal">Fermer</a>
    </div>
  </div>
</div>
</div>
<!-- End Modal -->


<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
</div>

    </div>
  </div>
</div>

                          
</div><!-- END row -->

                    

<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.master_panel', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/verdin/pedagogie.verdin.ma/resources/views/enseignants/documents.blade.php ENDPATH**/ ?>