

<?php $__env->startSection('title'); ?> Agents <?php $__env->stopSection(); ?>

<?php $__env->startSection('CSS'); ?> 


<link rel="stylesheet" type="text/css" href="<?php echo e(url('/')); ?>/js/datatables/dataTables.bootstrap4.min.css">

<link rel="stylesheet" href="<?php echo e(url('/')); ?>/assets/vendor/datepicker/tempusdominus-bootstrap-4.css" />

<style type="text/css">
.figure-attachment {
    min-height: 100px;
}
.fa-lg {
  font-size: 36px !important;
}
</style>

<?php $__env->stopSection(); ?>



<?php $__env->startSection('content'); ?>


<!-- ============================================================== -->
                  <!-- pageheader  -->
                  <!-- ============================================================== -->
                  <div class="row">
                      <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                          <div class="page-header">
                              <h3 class="mb-2">Agents</h3>
                          </div>
                      </div>
                  </div>
                  <!-- ============================================================== -->
                  <!-- end pageheader  -->
                  <!-- ============================================================== -->

<div class="row">    



<div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
  <div class="card">
    <h5 class="card-header">

<?php if(auth()->user()->super_admin == 1): ?>      
      <a href="#" class="btn btn-primary mb-1" data-toggle="modal" data-target="#exampleModal"><i class="fa fa-plus"></i> Ajouter </a>

      <a target="_black" href="https://reg.scolarite-verdin.ma/admin/agents" class="btn btn-primary mb-1"><i class="fa fa-users"></i> Agents Réglement/Gestion du Transport </a>
<?php endif; ?>

    </h5>
  <div class="card-body">



<div class="clearfix"></div>

<?php if(Session::has('error')): ?>

<div class="alert alert-danger alert-dismissible fade show text-center" role="alert">
  <strong><?php echo e(Session::get('error')); ?></strong>
  <button type="button" class="close" data-dismiss="alert" aria-label="Close">
    <span aria-hidden="true">&times;</span>
  </button>
</div>

<?php endif; ?>

<?php if(Session::has('success')): ?>
<div class="alert alert-success alert-dismissible fade show text-center" role="alert">
  <strong><?php echo e(Session::get('success')); ?></strong>
  <button type="button" class="close" data-dismiss="alert" aria-label="Close">
    <span aria-hidden="true">&times;</span>
  </button>
</div>
<?php endif; ?>

<div class="clearfix"></div>




<?php if(isset($_GET['agent_id'])): ?>

<?php $personnel = \App\User::find(e($_GET['agent_id'])); ?>

<?php if($personnel !== null): ?>


<div class="col-md-12" style="margin-bottom: 50px; border: 2px solid #ccc; padding: 50px;">

<form method="POST" action="<?php echo e(URL::route('update_agents_role', $personnel->id)); ?>"  enctype="multipart/form-data">

<?php echo e(csrf_field()); ?>


<div class="row">


<div class="col-md-6 mb-3">
    <label>Absences des élèves:</label>
    <select name="is_absences_agent" class="selectpicker" data-width="100%">
      <?php if($personnel->is_absences_agent == 1): ?>
        <option value="1" selected="selected">Oui</option>
        <option value="0">Non</option>
      <?php else: ?>
        <option value="0">Non</option>
        <option value="1">Oui</option>
      <?php endif; ?>
    </select>
</div>

<div class="col-md-6 mb-3">
    <label>Archives:</label>
    <select name="is_archives_agent" class="selectpicker" data-width="100%">
      <?php if($personnel->is_archives_agent == 1): ?>
        <option value="1" selected="selected">Oui</option>
        <option value="0">Non</option>
      <?php else: ?>
        <option value="0">Non</option>
        <option value="1">Oui</option>
      <?php endif; ?>
    </select>
</div>

<div class="col-md-6 mb-3">
    <label>Historique d'absences / Télécharger les absences:</label>
    <select name="is_historiqueabs_agent" class="selectpicker" data-width="100%">
      <?php if($personnel->is_historiqueabs_agent == 1): ?>
        <option value="1" selected="selected">Oui</option>
        <option value="0">Non</option>
      <?php else: ?>
        <option value="0">Non</option>
        <option value="1">Oui</option>
      <?php endif; ?>
    </select>
</div>

<div class="col-md-6 mb-3">
    <label>Pointage des heures de travail:</label>
    <select name="is_pointage_agent" class="selectpicker" data-width="100%">
      <?php if($personnel->is_pointage_agent == 1): ?>
        <option value="1" selected="selected">Oui</option>
        <option value="0">Non</option>
      <?php else: ?>
        <option value="0">Non</option>
        <option value="1">Oui</option>
      <?php endif; ?>
    </select>
</div>

<div class="col-md-6 mb-3">
    <label>Demande de renseignements:</label>
    <select name="is_renseignm_agent" class="selectpicker" data-width="100%">
      <?php if($personnel->is_renseignm_agent == 1): ?>
        <option value="1" selected="selected">Oui</option>
        <option value="0">Non</option>
      <?php else: ?>
        <option value="0">Non</option>
        <option value="1">Oui</option>
      <?php endif; ?>
    </select>
</div>

<div class="col-md-6 mb-3">
    <label>Demande documents (Parents):</label>
    <select name="is_demandedocs_agent" class="selectpicker" data-width="100%">
      <?php if($personnel->is_demandedocs_agent == 1): ?>
        <option value="1" selected="selected">Oui</option>
        <option value="0">Non</option>
      <?php else: ?>
        <option value="0">Non</option>
        <option value="1">Oui</option>
      <?php endif; ?>
    </select>
</div>

<div class="col-md-6 mb-3">
    <label>Gestion des charges:</label>
    <select name="is_charges_agent" class="selectpicker" id="is_charges_agent" data-width="100%">
      <?php if($personnel->is_charges_agent == 1): ?>
        <option value="1" selected="selected">Oui</option>
        <option value="0">Non</option>
      <?php else: ?>
        <option value="0">Non</option>
        <option value="1">Oui</option>
      <?php endif; ?>
    </select>
</div>



<div class="col-md-6 mb-3">
    <label>Assiduité:</label>
    <select name="is_assiduite_agent" class="selectpicker" data-width="100%">
      <?php if($personnel->is_assiduite_agent == 1): ?>
        <option value="1" selected="selected">Oui</option>
        <option value="0">Non</option>
      <?php else: ?>
        <option value="0">Non</option>
        <option value="1">Oui</option>
      <?php endif; ?>
    </select>
</div>

<div class="col-md-12 mb-3">
    <label>Affectation Enseignants-Séances:</label>
    <select name="is_affectation_agent" class="selectpicker" data-width="100%">
        <?php if($personnel->is_affectation_agent == 1): ?>
        <option value="1" selected="selected">Oui</option>
        <option value="0">Non</option>
      <?php else: ?>
        <option value="0">Non</option>
        <option value="1">Oui</option>
      <?php endif; ?>
    </select>
</div>

<div class="col-md-12 mb-5">

<?php 
$classes_charges = array(
  5 => '1000 - Personnel',
  6 => '2000 - Transport',
  7 => '3000 - Frais d\'exploitation',
  8 => '4000 - Charges sociales',
);


$allowed_charges = explode(",", $personnel->agent_allowed_charges);
?>
    <label>Les classes de charges autorisées:</label>
    <select name="agent_allowed_charges[]" class="selectpicker" id="allowed_charges" data-width="100%" multiple="multiple">
      <?php $__currentLoopData = $classes_charges; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $classes_charge): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <option value="<?php echo e($key); ?>"><?php echo e($classes_charge); ?></option>
      <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </select>

</div>


<div class="clearfix"></div>


  <div class="col-md-6 mb-3">
    <div class="form-group">
    <label>Nom</label>
    <div class="input-group">
    <div class="input-group-prepend"><span class="input-group-text"><i class="fa fa-edit"></i></span></div>
    <input name="last_name" type="text" class="form-control" value="<?php echo e($personnel->last_name); ?>" required>
    </div>
    </div>
  </div>

  <div class="col-md-6 mb-3">
    <div class="form-group">
    <label>Prénom</label>
    <div class="input-group">
    <div class="input-group-prepend"><span class="input-group-text"><i class="fa fa-edit"></i></span></div>
    <input name="first_name" type="text" class="form-control" value="<?php echo e($personnel->first_name); ?>" required>
    </div>
    </div>
  </div>

</div>



<div class="row">

  <div class="col-md-6">
    <div class="form-group">
    <label>Téléphone</label>
    <div class="input-group">
    <div class="input-group-prepend"><span class="input-group-text"><i class="fa fa-phone"></i></span></div>
    <input name="phone" type="text" class="form-control" value="<?php echo e($personnel->phone); ?>">
    </div>
    </div>
  </div>

  <div class="col-md-6">
    <div class="form-group">
    <label>Email</label>
    <div class="input-group">
    <div class="input-group-prepend"><span class="input-group-text"><i class="fa fa-envelope"></i></span></div>
    <input name="email" type="email" class="form-control" value="<?php echo e($personnel->email); ?>">
    </div>
    </div>
    <?php if($errors->first('email')): ?>
      <small class="form-text text-danger"><?php echo e($errors->first('email')); ?></small>
    <?php endif; ?>
  </div>

</div>


<div class="row">
  <div class="col-md-12">
      <label>Image</label>
        <div class="custom-file">
          <input type="file" name="image">
          
        </div>
        <?php if($errors->first('image')): ?>
          <small class="form-text text-danger"><?php echo e($errors->first('image')); ?></small>
        <?php endif; ?>
    </div>
</div>



<div class="row">
<div class="col-md-12 mt-3">
    <button class="btn btn-primary" type="submit">Modifier</button>
</div>
</div>

</form>

<div class="clearfix"></div><hr>

<form method="POST" action="<?php echo e(URL::route('personnel_password_update', $personnel->id)); ?>">

<?php echo e(csrf_field()); ?>


<div class="row">

  <div class="col-md-4">
    <div class="form-group">
    <label>Nom d'utilisateur</label>
    <div class="input-group">
    <div class="input-group-prepend"><span class="input-group-text">@</span></div>
    <input name="username" type="text" class="form-control" value="<?php echo e($personnel->username); ?>">
    </div>
    </div>
    <?php if($errors->first('username')): ?>
      <small class="form-text text-danger"><?php echo e($errors->first('username')); ?></small>
    <?php endif; ?>
  </div>

  <div class="col-md-4">
    <div class="form-group">
    <label>Mot de passe</label>
    <div class="input-group">
    <div class="input-group-prepend"><span class="input-group-text" style="cursor: pointer; " onclick="generatePassword();">Générer</span></div>
    <input name="password" type="text" id="inputPassword" class="form-control input-lg" required="required">
    </div>
    </div>
  </div>

  <div class="col-md-4">
      <label>Expiration du mot de passe:</label>
      <div class="form-group">
      <div class="input-group date" id="datetimepickerdateHon" data-target-input="nearest">

      <input name="date_expire_passe" type="text" class="form-control datetimepicker-input" data-target="#datetimepickerdateHon" style="height: 40px;"value="<?php echo e($personnel->date_expire_passe); ?>" required="required"  />
      
        <div class="input-group-append" data-target="#datetimepickerdateHon" data-toggle="datetimepicker">
        <div class="input-group-text"><i class="far fa-calendar-alt"></i></div>
        </div>
      </div>
    </div>
  </div>




</div>


<script type="text/javascript">

function generatePassword() {
    var length = 8,
        charset = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789!@#$%&*",
        retVal = "";
    for (var i = 0, n = charset.length; i < length; ++i) {
        retVal += charset.charAt(Math.floor(Math.random() * n));
    }

  //  return retVal;
    $('#inputPassword').val(retVal); 
}

</script> 

<div class="row">
<div class="col-md-12">
    <button class="btn btn-danger" type="submit">Modifier</button>
</div>
</div>

</form>

</div>


<?php endif; ?>

<?php else: ?> 

<!-- Modal -->
<div class="modal fade" id="exampleModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
<div class="modal-dialog modal-lg" role="document">
  <div class="modal-content">
    <div class="modal-header">
      <h5 class="modal-title" id="exampleModalLabel">Ajouter</h5>
      <a href="#" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></a>
    </div>
    <div class="modal-body">

<form method="POST" action="<?php echo e(URL::route('store_agents_role')); ?>"  enctype="multipart/form-data">

<?php echo e(csrf_field()); ?>


<div class="row">


  <div class="col-md-6">
    <div class="form-group">
    <label>Nom</label>
    <div class="input-group">
    <div class="input-group-prepend"><span class="input-group-text"><i class="fas fa-address-card"></i></span></div>
    <input name="last_name" type="text" class="form-control" value="<?php echo e(old('last_name')); ?>" required>
    </div>
    </div>
  </div>

  <div class="col-md-6">
    <div class="form-group">
    <label>Prénom</label>
    <div class="input-group">
    <div class="input-group-prepend"><span class="input-group-text"><i class="fas fa-address-card"></i></span></div>
    <input name="first_name" type="text" class="form-control" value="<?php echo e(old('first_name')); ?>" required>
    </div>
    </div>
  </div>

</div>



<div class="row">

  <div class="col-md-6">
    <div class="form-group">
    <label>Téléphone</label>
    <div class="input-group">
    <div class="input-group-prepend"><span class="input-group-text"><i class="fa fa-phone"></i></span></div>
    <input name="phone" type="text" class="form-control" value="<?php echo e(old('phone')); ?>">
    </div>
    </div>
  </div>

  <div class="col-md-6">
    <div class="form-group">
    <label>Email</label>
    <div class="input-group">
    <div class="input-group-prepend"><span class="input-group-text"><i class="fa fa-envelope"></i></span></div>
    <input name="email" type="email" class="form-control" value="<?php echo e(old('email')); ?>" required="required">
    </div>
    </div>
    <?php if($errors->first('email')): ?>
      <small class="form-text text-danger"><?php echo e($errors->first('email')); ?></small>
    <?php endif; ?>
  </div>

</div>


<div class="clearfix"></div><hr>

<div class="row">


  <div class="col-md-4">
    <div class="form-group">
    <label>Nom d'utilisateur</label>
    <div class="input-group">
    <div class="input-group-prepend"><span class="input-group-text">@</span></div>
    <input name="username" type="text" class="form-control" value="<?php echo e(old('username')); ?>" required="required">
    </div>
    </div>
    <?php if($errors->first('username')): ?>
      <small class="form-text text-danger"><?php echo e($errors->first('username')); ?></small>
    <?php endif; ?>
  </div>

  <div class="col-md-4">
    <div class="form-group">
    <label>Mot de passe</label>
    <div class="input-group">
    <div class="input-group-prepend"><span class="input-group-text" style="cursor: pointer; " onclick="generatePassword();">Générer</span></div>
    <input name="password" type="text" id="inputPassword" class="form-control input-lg" required="required">
    </div>
    </div>
  </div>

  <div class="col-md-4">
      <label>Expiration du mot de passe:</label>
      <div class="form-group">
      <div class="input-group date" id="datetimepickerdateHon" data-target-input="nearest">

      <input name="date_expire_passe" type="text" class="form-control datetimepicker-input" data-target="#datetimepickerdateHon" style="height: 40px;"value="<?php echo e(date('d/m/Y')); ?>" required="required"  />
      
        <div class="input-group-append" data-target="#datetimepickerdateHon" data-toggle="datetimepicker">
        <div class="input-group-text"><i class="far fa-calendar-alt"></i></div>
        </div>
      </div>
    </div>
  </div>

  <div class="col-md-12">
        <div class="form-group">
          <label>Image</label>
          <input type="file" name="image" class="form-control">
        </div>
  </div>

</div>


<div class="clearfix"></div><hr>

<div class="row">

<div class="col-md-6 mb-3">
    <label>Absences des élèves:</label>
    <select name="is_absences_agent" class="selectpicker" data-width="100%">
        <option value="0">Non</option>
        <option value="1">Oui</option>
    </select>
</div>

<div class="col-md-6 mb-3">
    <label>Archives:</label>
    <select name="is_archives_agent" class="selectpicker" data-width="100%">
        <option value="0">Non</option>
        <option value="1">Oui</option>
    </select>
</div>

<div class="col-md-6 mb-3">
    <label>Historique d'absences / Télécharger les absences:</label>
    <select name="is_historiqueabs_agent" class="selectpicker" data-width="100%">
        <option value="0">Non</option>
        <option value="1">Oui</option>
    </select>
</div>

<div class="col-md-6 mb-3">
    <label>Pointage des heures de travail:</label>
    <select name="is_pointage_agent" class="selectpicker" data-width="100%">
        <option value="0">Non</option>
        <option value="1">Oui</option>
    </select>
</div>

<div class="col-md-6 mb-3">
    <label>Demande de renseignements:</label>
    <select name="is_renseignm_agent" class="selectpicker" data-width="100%">
        <option value="0">Non</option>
        <option value="1">Oui</option>
    </select>
</div>

<div class="col-md-6 mb-3">
    <label>Demande documents:</label>
    <select name="is_demandedocs_agent" class="selectpicker" data-width="100%">
        <option value="0">Non</option>
        <option value="1">Oui</option>
    </select>
</div>

<div class="col-md-6 mb-3">
    <label>Gestion des charges:</label>
    <select name="is_charges_agent" class="selectpicker" data-width="100%">
        <option value="0">Non</option>
        <option value="1">Oui</option>
    </select>
</div>

<div class="col-md-6 mb-3">
    <label>Assiduité:</label>
    <select name="is_assiduite_agent" class="selectpicker" data-width="100%">
        <option value="0">Non</option>
        <option value="1">Oui</option>
    </select>
</div>

<div class="col-md-6 mb-3">
    <label>Affectation Enseignants-Séances:</label>
    <select name="is_affectation_agent" class="selectpicker" data-width="100%">
        <option value="0">Non</option>
        <option value="1">Oui</option>
    </select>
</div>



</div>



<script type="text/javascript">

function generatePassword() {
    var length = 8,
        charset = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789!@#$%&*",
        retVal = "";
    for (var i = 0, n = charset.length; i < length; ++i) {
        retVal += charset.charAt(Math.floor(Math.random() * n));
    }

  //  return retVal;
    $('#inputPassword').val(retVal); 
}

</script> 

<div class="row">
<div class="col-md-12 mt-3">
    <button class="btn btn-success btn-block" type="submit">Ajouter</button>
</div>
</div>

</form>

    </div>
    <div class="modal-footer">
      <a href="#" class="btn btn-dark" data-dismiss="modal">Fermer</a>
    </div>
  </div>
</div>
</div>
<!-- End Modal -->

<?php endif; ?>



      <div class="table-responsive">
          <table class="table table-striped table-bordered first">
            <thead>
            <tr class="text-uppercase">
              <th></th>
              <th>Nom et Prénom</th>
              <th>Les tâches</th>
              <th>Nom d'utilisateur</th>
              <th>Action</th>
            </tr>
            </thead>
            <tbody>

             <?php $__currentLoopData = $agents; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $agen): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr style="font-size: 0.9em;">
                  

                   <td>
                    <?php if(!empty($agen->image)): ?>
                    <img style="max-width: 65px; max-height: 65px;" src="<?php echo e(url('/')); ?>/uploads/images/<?php echo e($agen->image); ?>" alt="" class="rounded-circle user-avatar-xxl">
                    <?php else: ?>
                    <img style="max-width: 65px; max-height: 65px;" src="<?php echo e(url('/')); ?>/uploads/images/user.png" alt="" class="rounded-circle user-avatar-xxl">
                    <?php endif; ?>
                  </td>
                                           
                  <td><?php echo e($agen->last_name . ' ' . $agen->first_name); ?></td>


                  <td>
<?php if($agen->is_absences_agent == 1): ?> 
<span class="badge badge-info mb-2"> Absences des élèves </span>
<?php endif; ?>

<?php if($agen->is_historiqueabs_agent == 1): ?> 
<span class="badge badge-info mb-2"> Historique/Télécharger les absences </span>
<?php endif; ?>

<?php if($agen->is_pointage_agent == 1): ?> 
<span class="badge badge-info mb-2"> Pointage des heures de travail </span>
<?php endif; ?>

<?php if($agen->is_archives_agent == 1): ?>
<span class="badge badge-info mb-2"> Archives </span>
<?php endif; ?>

<?php if($agen->is_renseignm_agent == 1): ?>
<span class="badge badge-info mb-2"> Demande de renseignements </span>
<?php endif; ?>


<?php if($agen->is_demandedocs_agent == 1): ?>
<span class="badge badge-info mb-2"> Demande documents </span>
<?php endif; ?>

<?php if($agen->is_assiduite_agent == 1): ?>
<span class="badge badge-info mb-2"> Assiduité </span>
<?php endif; ?>

<?php if($agen->is_affectation_agent == 1): ?>
<span class="badge badge-info mb-2"> Affectation Enseignants-Séances </span>
<?php endif; ?>


<?php if($agen->is_charges_agent == 1): ?>

<?php 
$listclasses_charges = array(
  5 => '1000 - Personnel',
  6 => '2000 - Transport',
  7 => '3000 - Frais d\'exploitation',
  8 => '4000 - Charges sociales',
);

$allowed_charges = explode(",", $agen->agent_allowed_charges);
?>

  <?php $__currentLoopData = $listclasses_charges; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key2 => $listclasses_charge): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
  <?php if(in_array($key2, $allowed_charges)): ?>
  <span class="badge badge-info mb-2"><?php echo e($listclasses_charge); ?></span>
  <?php endif; ?>
<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
  
<?php endif; ?>


                  </td>

                  <td><?php echo e($agen->username); ?></td>

                  
                    <td>
<?php if(auth()->user()->super_admin == 1): ?>
                        <a href="<?php echo e(URL::current() . '?agent_id=' . $agen->id); ?>" class="btn btn-success btn-sm mb-1"><i class="fa fa-edit"></i> Modifier </a>

                        <a onclick="return confirm('Supprimer?')" href="<?php echo e(URL::route('personnel_destroy', $agen->id)); ?>" class="btn btn-danger btn-sm mb-1"><i class="fa fa-trash"></i> Supprimer </a>
<?php endif; ?>                       
                      </td>

                    </tr>

                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                  </tbody>
                  </table>
               </div>







    </div>
  </div>
</div>

                          
</div><!-- END row -->




<?php $__env->stopSection(); ?>



<?php $__env->startSection('JS'); ?> 

<?php if(isset($_GET['agent_id'])): ?>
<script type="text/javascript">
$('#allowed_charges').val(<?php echo json_encode($allowed_charges); ?>);
</script>


<script type="text/javascript">
$(document).ready(function () { 
  
  $('#is_charges_agent').on('change',function(eg){

    var egg = eg.target.value;

    if (egg == 1) {
      $("#allowed_charges").attr('required', 'required');
    } else {
      $("#allowed_charges").removeAttr('required');
    }

  });

});
</script>


<?php endif; ?>




<script src="<?php echo e(url('/')); ?>/assets/vendor/datepicker/moment.js"></script>
<script src="<?php echo e(url('/')); ?>/assets/vendor/datepicker/tempusdominus-bootstrap-4.js"></script>
<script src="<?php echo e(url('/')); ?>/assets/vendor/datepicker/datepicker.js"></script>

<script src="<?php echo e(url('/')); ?>/assets/vendor/datepicker/fr.js"></script>

<script type="text/javascript">
     $(function () {
        $('#datetimepickerdateHon').datetimepicker({
          format: 'DD/MM/YYYY',
          locale: 'fr'
      });
    });

</script>


<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.other_panel', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/verdin/pedagogie.verdin.ma/resources/views/agents/index.blade.php ENDPATH**/ ?>