@extends('layouts.master_panel')

@section('title') Alerts @stop

@section('CSS') 


<link rel="stylesheet" type="text/css" href="{{url('/')}}/js/datatables/dataTables.bootstrap4.min.css">

<link rel="stylesheet" href="{{url('/')}}/assets/vendor/datepicker/tempusdominus-bootstrap-4.css" />

<link rel="stylesheet" href="{{url('/')}}/assets/vendor/summernote/css/summernote-bs4.css">

@stop

@section('JS') 


<script src="{{url('/')}}/js/datatables/jquery.dataTables.min.js"></script>
<script src="{{url('/')}}/js/datatables/dataTables.bootstrap4.min.js"></script>

<script type="text/javascript" class="init">
  $(document).ready(function() {
    $("#example").dataTable({ "language": { "url": "{{ url('/') }}/js/datatables/lang/fr.json" },
      "order": [[ 0, "desc" ]]
    });
  });
  </script>


<script src="{{url('/')}}/assets/vendor/datepicker/moment.js"></script>
<script src="{{url('/')}}/assets/vendor/datepicker/tempusdominus-bootstrap-4.js"></script>
<script src="{{url('/')}}/assets/vendor/datepicker/datepicker.js"></script>

<script src="{{url('/')}}/assets/vendor/datepicker/fr.js"></script>

<script type="text/javascript">
    $(function () {
        $('#datetimepickerdate').datetimepicker({
          format: 'D/M/YYYY',
          locale: 'fr'
      });
    });

</script>


<script src="{{url('/')}}/assets/vendor/summernote/js/summernote-bs4.js"></script>

<script>
    $(document).ready(function() {
        $('#summernote').summernote({
            height: 150

        });
    });
</script>


<script type="text/javascript">
function ValidateSize(file) {
  var FileSize = file.files[0].size / 1024 / 1024; // in MB
  if (FileSize > 10) {
      $('#file').val(''); //for clearing with Jquery
      alert('La taille du fichier dépasse 10 Mo');
      
  } 
}
</script>

@stop


@section('content')


                  <!-- ============================================================== -->
                  <!-- pageheader  -->
                  <!-- ============================================================== -->
                  <div class="row">
                      <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                          <div class="page-header">
                              <h3 class="mb-2">Alerts  </h3>
                           
                              <div class="page-breadcrumb">
                                  <nav aria-label="breadcrumb">
                                      <ol class="breadcrumb">
                                          <li class="breadcrumb-item"><a href="{{ URL::route('admin_index') }}" class="breadcrumb-link">Accueil</a></li>
                                          <li class="breadcrumb-item active" aria-current="page">Alerts  </li>
                                      </ol>
                                  </nav>
                              </div>
                          </div>
                      </div>
                  </div>
                  <!-- ============================================================== -->
                  <!-- end pageheader  -->
                  <!-- ============================================================== -->


<div class="row">


<div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
  <div class="card">  
  <div class="card-body">


<div class="clearfix"></div>

@if(Session::has('error'))

<div class="alert alert-danger alert-dismissible fade show text-center" role="alert">
  <strong>{{ Session::get('error') }}</strong>
  <button type="button" class="close" data-dismiss="alert" aria-label="Close">
    <span aria-hidden="true">&times;</span>
  </button>
</div>

@endif

@if(Session::has('success'))
<div class="alert alert-success alert-dismissible fade show text-center" role="alert">
  <strong>{{ Session::get('success') }}</strong>
  <button type="button" class="close" data-dismiss="alert" aria-label="Close">
    <span aria-hidden="true">&times;</span>
  </button>
</div>
@endif

<div class="clearfix"></div>

      <div class="table-responsive">
          <table id="example" class="table table-striped table-bordered first">
            <thead>
            <tr class="text-uppercase">
              <th style="display: none;">#</th>
              <th>Élève</th>
              <th>Classe/Matière</th>
              <th style="width: 25%">Devoir</th>
              <th>Alert</th>
              <th>Date</th>
            </tr>
            </thead>
            <tbody>

@foreach($devoirs_alerts as $devoirs_alert)
<?php $GetDevoir = \App\Devoirs::find($devoirs_alert->devoir_id); ?>
@if($GetDevoir !== null)

                <tr>

                  <td style="display: none;">{{ $devoirs_alert->id }}</td>

                  <td>{{ $devoirs_alert->student->last_name . ' ' . $devoirs_alert->student->first_name }}</td>

                  <td>
                    <?php $FindSubject = \App\Subjects::find($GetDevoir->subject_id); ?>
                    {{ $GetDevoir->classe->name }} @if($FindSubject !== null ) - {{ $FindSubject->name }} @endif
                  </td>

                  <td>{{ $GetDevoir->title }}</td>

                  <td>
                    @if($devoirs_alert->alert_type == 1)
                    <i class="fas fa-info-circle text-warning" style="font-size: 18px;"></i> <label class="text-warning">Incomplet</label>
                    @elseif($devoirs_alert->alert_type == 2)
                    <i class="fas fa-minus-circle text-danger" style="font-size: 18px;"></i> <label class="text-danger">Non Fait</label>
                    @endif
                  </td>

                  <td>
                    <?php $enTofr = DateTime::createFromFormat('Y-m-d H:i', substr($devoirs_alert->created_at, 0, 16)); echo $enTofr->format('d/m/Y H:i'); ?>
                  </td>
                  

                    </tr>
@endif
@endforeach
                  </tbody>
                  </table>
               </div>

    </div>
  </div>
</div>

                                     


</div><!-- END row -->
                
               

@stop