@extends('layouts.master_panel')

@section('title') التوزيع الدوري  @stop

@section('CSS') 


<link rel="stylesheet" href="{{url('/')}}/assets/vendor/datepicker/tempusdominus-bootstrap-4.css" />

<link rel="stylesheet" href="{{url('/')}}/assets/vendor/summernote/css/summernote-bs4.css">

@stop

@section('JS') 

<script src="{{url('/')}}/assets/vendor/datepicker/moment.js"></script>
<script src="{{url('/')}}/assets/vendor/datepicker/tempusdominus-bootstrap-4.js"></script>
<script src="{{url('/')}}/assets/vendor/datepicker/datepicker.js"></script>

<script src="{{url('/')}}/assets/vendor/datepicker/fr.js"></script>

<script type="text/javascript">
    $(function () {
        $('#datetimepicker').datetimepicker({
          format: 'D/M/YYYY',
          locale: 'fr'
      });
    });

    $('#datetimepicker4').datetimepicker({
        format: 'D/M/YYYY',
        locale: 'fr'
    });

</script>


<script src="{{url('/')}}/assets/vendor/summernote/js/summernote-bs4.js"></script>

<script>
    $(document).ready(function() {
        $('#summernote').summernote({
            height: 200

        });
    });
</script>



@stop


@section('content')
                  
                  <!-- ============================================================== -->
                  <!-- pageheader  -->
                  <!-- ============================================================== -->
                  <div class="row">
                      <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                          <div class="page-header">
                              <h3 class="mb-2">التوزيع الدوري  </h3>
                           
                              <div class="page-breadcrumb">
                                  <nav aria-label="breadcrumb">
                                      <ol class="breadcrumb">
                                          <li class="breadcrumb-item"><a href="{{ URL::route('enseignant_index') }}" class="breadcrumb-link">Accueil</a></li>
                                          <li class="breadcrumb-item active" aria-current="page">التوزيع الدوري  </li>
                                      </ol>
                                  </nav>
                              </div>
                          </div>
                      </div>
                  </div>
                  <!-- ============================================================== -->
                  <!-- end pageheader  -->
                  <!-- ============================================================== -->


<div class="row">

@if(isset($_GET['subject_id']))

<div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
<div class="card">
  <div class="card-body">

<?php 
$repartition = \App\Repartition::where('semestre', e($_GET['smtr']))->where('subject_id', e($_GET['subject_id']))->where('teacher_id', auth()->user()->id)->orderBy('id', 'desc')->get();


 ?>    

 @if(count($repartition) < 16) 
<div class="alert alert-warning alert-dismissible fade show" role="alert">
  <strong>Veuillez compléter toutes les semaines.</strong>
  <a href="#" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">×</span></a>
</div>
 @endif  

    <?php $week_array = array(); ?>

    @foreach($repartition as $reparti)

      <?php $week_array[] = $reparti->week ?>

    @endforeach


<?php $listweeks = [1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16]; ?>
    
    @foreach($listweeks as $listwk)

      @if(in_array($listwk, $week_array)) 
        <span style="font-size: 16px;" class="badge badge-primary mr-2 mb-2"> <i class="fas fa-check-circle"></i> semaine {{ $listwk }}</span>
      @else
        <span style="font-size: 16px;" class="badge badge-light mr-2 mb-2"> <i class="fas fa-hourglass-half"></i> semaine {{ $listwk }}</span>
      @endif

    @endforeach
    


  </div>
</div>
</div>
@endif

<div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
  <div class="card">
  <div class="card-body">



<form method="GET" class="form-row">

  <div class="col-md-12 mb-3">
    <label>Semestre</label>
    <select name="smtr" class="selectpicker" data-width="100%" required="required">
@if(isset($_GET['smtr']))
  @if(e($_GET['smtr']) == 1)
    <option selected="selected" value="1">Semestre 1</option>
    <option value="2">Semestre 2</option>
  @else
    <option selected="selected" value="2">Semestre 2</option>
    <option value="1">Semestre 1</option>
  @endif
@else
<option value="1">Semestre 1</option>
<option value="2">Semestre 2</option>
@endif 

    </select>
  </div>


  <div class="col-md-6 mb-3">
      <label>Matières / Classes</label>
      <select name="subject_id" class="selectpicker" data-width="100%" required="required" onchange="this.form.submit()" >

@if(isset($_GET['subject_id']) AND !empty($_GET['subject_id']))

<?php 
$getSubject = \App\Subjects::find(e($_GET['subject_id'])); 
$FindClass = \App\Classes::find($getSubject->class_id);
?>


    <option value="{{ $getSubject->id }}">{{ $getSubject->name }} ({{ $FindClass->name }})</option>
@else       
    <option value="">Choisir</option>
@endif        

          @foreach($subjects as $subject)

<?php $getclass = \App\Classes::find($subject->class_id); ?>

          <option value="{{ $subject->id }}">{{ $subject->name }} ({{ $getclass->name }})</option>
          @endforeach
      </select>
  </div>

  
  
  <div class="col-md-6 mb-3">
    <label>Semaines</label>
      <select name="week" class="selectpicker" data-width="100%" onchange="this.form.submit()" required="required" >

@if(isset($_GET['week']))
  <option value="{{ e($_GET['week']) }}">Semaine {{ e($_GET['week']) }}</option>
@else
<option value="1">Choisir</option>
@endif        
        @for ($i=1; $i <= 16; $i++)
          <option value="{{ $i }}">Semaine {{ $i }}</option>
         @endfor
      </select>
  </div>

 

</form>


  </div>
  </div>
</div>


@if(isset($_GET['subject_id']) AND !empty($_GET['subject_id']) AND !empty($_GET['week']))



<div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
  <div class="card">
  <div class="card-body">

@if(Session::has('error'))

<div class="alert alert-danger alert-dismissible fade show text-center" role="alert">
  <strong>{{ Session::get('error') }}</strong>
  <button type="button" class="close" data-dismiss="alert" aria-label="Close">
    <span aria-hidden="true">&times;</span>
  </button>
</div>

@endif

@if(Session::has('success'))
<div class="alert alert-success alert-dismissible fade show text-center" role="alert">
  <strong>{{ Session::get('success') }}</strong>
  <button type="button" class="close" data-dismiss="alert" aria-label="Close">
    <span aria-hidden="true">&times;</span>
  </button>
</div>
@endif

<div class="clearfix"></div>



<?php $getSubject = \App\Subjects::find(e($_GET['subject_id'])); ?>


@if($getSubject !== null)


<form method="POST" action="{{ URL::route('enseignant_store_repartition') }}">

{{ csrf_field() }}

<input type="hidden" name="subject_id" value="{{ $getSubject->id }}">
<input type="hidden" name="week" value="{{ e($_GET['week']) }}">
<input type="hidden" name="semestre" value="{{ e($_GET['smtr']) }}">

<input type="hidden" name="class_id" value="{{ $getSubject->classe->id }}">

<?php 
$checkRepartition =  \App\Repartition::where('teacher_id', auth()->user()->id)->where('class_id', $getSubject->classe->id)->where('subject_id', $getSubject->id)->where('week', e($_GET['week']))->where('semestre', e($_GET['smtr']))->first();
 ?>

<div class="form-row">

  <div class="col-md-6 mb-3">
    <label>Date du:</label>
    <div class="form-group">
    <div class="input-group date" id="datetimepicker4" data-target-input="nearest">
@if($checkRepartition !== null)      
      <input name="date_start" type="text" class="form-control datetimepicker-input" data-target="#datetimepicker4" value="{{ $checkRepartition->date_start }}" />
@else
    <input name="date_start" type="text" class="form-control datetimepicker-input" data-target="#datetimepicker4" />
@endif      
      <div class="input-group-append" data-target="#datetimepicker4" data-toggle="datetimepicker">
      <div class="input-group-text"><i class="far fa-calendar-alt"></i></div>
      </div>
    </div>
  </div>
  </div>

  <div class="col-md-6 mb-3">
    <label>Au:</label>
    <div class="form-group">
    <div class="input-group date" id="datetimepicker" data-target-input="nearest">
@if($checkRepartition !== null)      
      <input name="date_end" type="text" class="form-control datetimepicker-input" data-target="#datetimepicker" value="{{ $checkRepartition->date_end }}" />
@else   
      <input name="date_end" type="text" class="form-control datetimepicker-input" data-target="#datetimepicker" />
@endif   
      <div class="input-group-append" data-target="#datetimepicker" data-toggle="datetimepicker">
      <div class="input-group-text"><i class="far fa-calendar-alt"></i></div>
      </div>
    </div>
  </div>
  </div>

  <div class="col-md-12 mb-3">
    <label>Détails:</label>
    <textarea name="details" id="summernote" class="form-control">@if($checkRepartition !== null) <?php echo html_entity_decode($checkRepartition->details); ?>  @endif</textarea>
  </div>

  <div class="clearfix"></div><hr>

 
</div>



<div class="col-md-12 mb-3">
    <button class="btn btn-success btn-block" type="submit">Enregistrer</button>
</div>


</form>


@endif







    </div>
  </div>
</div>


@endif

                          
</div><!-- END row -->

                    

@stop