<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class SuiviPreparation extends Model
{
    protected $table = 'suivi_preparation';

    protected $guarded = ['id', 'created_at'];

    public function teacher()
	{
		return $this->belongsTo('App\User', 'teacher_id');
	}

	public function classe()
	{
		return $this->belongsTo('App\Classes', 'class_id');
	}

	public function subject()
	{
		return $this->belongsTo('App\Subjects', 'subject_id');
	}
	
    public function student()
	{
		return $this->belongsTo('App\User', 'student_id');
	}

}
