@extends('layouts.master_panel')

@section('title') Les devoirs Non-déposé  @stop

@section('CSS') 


<link rel="stylesheet" type="text/css" href="{{url('/')}}/js/datatables/dataTables.bootstrap4.min.css">

@stop

@section('JS') 


<script src="{{url('/')}}/js/datatables/jquery.dataTables.min.js"></script>
<script src="{{url('/')}}/js/datatables/dataTables.bootstrap4.min.js"></script>

<script type="text/javascript" class="init">
  $(document).ready(function() {
    $("#example").dataTable({ 
      "language": { "url": "{{ url('/') }}/js/datatables/lang/fr.json" },
      "order": [[ 0, "desc" ]]
    });
  });

  </script>

<script src="{{url('/')}}/assets/vendor/datepicker/moment.js"></script>
<script src="{{url('/')}}/assets/vendor/datepicker/tempusdominus-bootstrap-4.js"></script>
<script src="{{url('/')}}/assets/vendor/datepicker/datepicker.js"></script>

<script src="{{url('/')}}/assets/vendor/datepicker/fr.js"></script>

<script type="text/javascript">
    $(function () {
        $('#datetimepickerdate').datetimepicker({
          format: 'DD/MM/YYYY',
          locale: 'fr'
      });
    });

    $(function () {
        $('#datetimepickerdate2').datetimepicker({
          format: 'DD/MM/YYYY',
          locale: 'fr'
      });
    });

</script>



@stop


@section('content')


                  <!-- ============================================================== -->
                  <!-- pageheader  -->
                  <!-- ============================================================== -->
                  <div class="row">
                      <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                          <div class="page-header">
                              <h3 class="mb-2">Les devoirs Non-déposé </h3>
                           
                              <div class="page-breadcrumb">
                                  <nav aria-label="breadcrumb">
                                      <ol class="breadcrumb">
                                          <li class="breadcrumb-item"><a href="{{ URL::route('admin_index') }}" class="breadcrumb-link">Accueil</a></li>
                                          <li class="breadcrumb-item active" aria-current="page">Les devoirs Non-déposé</li>
                                      </ol>
                                  </nav>
                              </div>
                          </div>
                      </div>
                  </div>
                  <!-- ============================================================== -->
                  <!-- end pageheader  -->
                  <!-- ============================================================== -->


<div class="row">

<div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
  <div class="card">
    <h5 class="card-header">
      <a href="#" class="btn btn-primary ml-1 mb-1" data-toggle="modal" data-target="#exampleModal2"><i class="fas fa-search"></i> Vérifier le non-déposé</a>
    </h5>

    @if(isset($_GET['from']) AND isset($_GET['to']))
    <h3 class="card-header">
       du {{ $_GET['from'] }} au {{ $_GET['to'] }}
    </h3>
    @endif
  <div class="card-body">


<!-- Modal -->
<div class="modal fade" id="exampleModal2" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel2" aria-hidden="true">
<div class="modal-dialog" role="document">
  <div class="modal-content">
    <div class="modal-header">
      <h5 class="modal-title" id="exampleModalLabel2">Vérifier le non-déposé</h5>
      <a href="#" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></a>
    </div>
    <div class="modal-body">

<form method="GET" action="{{ URL::route('devoirs_non_depose') }}" class="row">


<div class="col-md-12 mb-2">
    <label>du:</label>
    <div class="form-group">
    <div class="input-group date" id="datetimepickerdate" data-target-input="nearest">

    <input name="from" type="text" class="form-control datetimepicker-input" data-target="#datetimepickerdate" />
    
      <div class="input-group-append" data-target="#datetimepickerdate" data-toggle="datetimepicker">
      <div class="input-group-text"><i class="far fa-calendar-alt"></i></div>
      </div>
    </div>
  </div>
</div>

<div class="col-md-12 mb-2">
    <label>au:</label>
    <div class="form-group">
    <div class="input-group date" id="datetimepickerdate2" data-target-input="nearest">

    <input name="to" type="text" class="form-control datetimepicker-input" data-target="#datetimepickerdate2" />
    
      <div class="input-group-append" data-target="#datetimepickerdate2" data-toggle="datetimepicker">
      <div class="input-group-text"><i class="far fa-calendar-alt"></i></div>
      </div>
    </div>
  </div>
</div>


<div class="col-md-12 mb-3">
    <button class="btn btn-success btn-block" type="submit">Vérifier le non-déposé</button>
</div>



</form>



    </div>

    <div class="modal-footer">
      <a href="#" class="btn btn-dark" data-dismiss="modal">Fermer</a>
    </div>

  </div>
</div>
</div>
<!-- End Modal -->

<div class="clearfix"></div>

      <div class="table-responsive">
          <table id="example" class="table table-striped table-bordered first">
            <thead>
            <tr class="text-uppercase">
              <th>Nom et Prénom</th>
              <th>Matière</th>
              <th>Classe</th>
              <th>état</th>
            </tr>
            </thead>
            <tbody>

<?php 
$settings = \App\Settings::first(); 

?>

@foreach($enseignants as $enseignant)

<?php $subjects = \App\Subjects::where('teacher_id', $enseignant->id)->orderBy('id', 'asc')->get(); ?>

  @foreach($subjects as $subject)

    <?php $checkDevoir = \App\Devoirs::where('year_id', $settings->default_year)->where('teacher_id', $enseignant->id)->where('subject_id', $subject->id)->whereBetween('created_at', [$from, $to])->first(); ?>

          @if($checkDevoir == null)
                <tr>
                  <td>{{ $enseignant->last_name . ' ' . $enseignant->first_name }}</td>

                   <td>{{ $subject->name }}</td>
                   <td>{{ $subject->classe->name }}</td>

                  <td><i class="fas fa-info-circle text-danger" style="font-size: 18px;"></i> <label class="text-danger">Non déposé</label></td>
                </tr>
          @endif

    @endforeach

@endforeach
            </tbody>
          </table>
        </div>


    </div>
  </div>
</div>

                          
</div><!-- END row -->
                
               

@stop