@extends('layouts.master_panel')

@section('title') Evaluation des apprentissages @stop

@section('CSS') 


<link rel="stylesheet" type="text/css" href="{{url('/')}}/js/datatables/dataTables.bootstrap4.min.css">

<link rel="stylesheet" href="{{url('/')}}/assets/vendor/datepicker/tempusdominus-bootstrap-4.css" />


@stop

@section('JS') 


<script src="{{url('/')}}/js/datatables/jquery.dataTables.min.js"></script>
<script src="{{url('/')}}/js/datatables/dataTables.bootstrap4.min.js"></script>

<script type="text/javascript" class="init">
  $(document).ready(function() {
    $("#example").dataTable({ "language": { "url": "{{ url('/') }}/js/datatables/lang/fr.json" },
      "order": [[ 0, "desc" ]]
    });
  });
  </script>


<script src="{{url('/')}}/assets/vendor/datepicker/moment.js"></script>
<script src="{{url('/')}}/assets/vendor/datepicker/tempusdominus-bootstrap-4.js"></script>
<script src="{{url('/')}}/assets/vendor/datepicker/datepicker.js"></script>

<script src="{{url('/')}}/assets/vendor/datepicker/fr.js"></script>

<script type="text/javascript">
    $(function () {
        $('#datetimepickerdate').datetimepicker({
          format: 'DD/M/YYYY',
          locale: 'fr'
      });
    });

</script>



<script type="text/javascript">
$(document).ready(function () { 

  $('.donebox').change(function() {

      var id = this.id;
      var idSplit = id.split("-");

      if(this.checked) {
        $('#is_absent'+idSplit[1]).val('1');
      } else {
        $('#is_absent'+idSplit[1]).val('0'); 
      } 
  
  });


});
</script>


@stop


@section('content')


                  <!-- ============================================================== -->
                  <!-- pageheader  -->
                  <!-- ============================================================== -->
                  <div class="row">
                      <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                          <div class="page-header">
                              <h3 class="mb-2">Evaluation des apprentissages </h3>
                           
                              <div class="page-breadcrumb">
                                  <nav aria-label="breadcrumb">
                                      <ol class="breadcrumb">
                                          <li class="breadcrumb-item"><a href="{{ URL::route('enseignant_index') }}" class="breadcrumb-link">Accueil</a></li>
                                          <li class="breadcrumb-item active" aria-current="page">Evaluation des apprentissages  </li>
                                      </ol>
                                  </nav>
                              </div>
                          </div>
                      </div>
                  </div>
                  <!-- ============================================================== -->
                  <!-- end pageheader  -->
                  <!-- ============================================================== -->


<div class="row">

<div class="col-md-12">
@if(Session::has('error'))

<div class="alert alert-danger alert-dismissible fade show text-center" role="alert">
  <strong>{{ Session::get('error') }}</strong>
  <button type="button" class="close" data-dismiss="alert" aria-label="Close">
    <span aria-hidden="true">&times;</span>
  </button>
</div>

@endif

@if(Session::has('success'))
<div class="alert alert-success alert-dismissible fade show text-center" role="alert">
  <strong>{{ Session::get('success') }}</strong>
  <button type="button" class="close" data-dismiss="alert" aria-label="Close">
    <span aria-hidden="true">&times;</span>
  </button>
</div>
@endif
</div>
<div class="clearfix"></div>


@if(isset($_GET['subject_id']))

<?php 

$GetSubject = \App\Subjects::find(e($_GET['subject_id']));

if ($GetSubject !== null) {

  $students = \App\User::where('is_student', true)->where('class_id', $GetSubject->class_id)->orderBy('last_name', 'asc')->get();

  $GetClass = \App\Classes::find($GetSubject->class_id);

 ?>

<div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
  <div class="card">
  <h5 class="card-header">Évaluations</h5>
  <div class="card-body">

<h4><strong>Classe et Matière:</strong> {{ $GetClass->name }} - {{ $GetSubject->name }}</h4>
<h4><strong>Note Sur:</strong> /{{ e($_GET['note_sur']) }}</h4>
<h4><strong>Date:</strong> {{ e($_GET['date']) }}</h4>
<div class="clearfix"></div><hr>


<form method="POST" action="{{ URL::route('controle_evaluations_store') }}" class="form-row">

 @csrf 


<input type="hidden" name="titre" value="{{ $_GET['titre'] }}">
<input type="hidden" name="subject_id" value="{{ $GetSubject->id }}">
<input type="hidden" name="class_id" value="{{ $GetSubject->class_id }}">
<input type="hidden" name="note_sur" value="{{ e($_GET['note_sur']) }}">
<input type="hidden" name="date" value="{{ e($_GET['date']) }}">

      <div class="table-responsive">
          <table class="table table-striped table-bordered first">
            <thead>
            <tr class="text-uppercase">
              <th>Nom et Prénom</th>
              <th>Absent(e)</th>
              <th>Note /{{ e($_GET['note_sur']) }}</th>
              <th>état</th>
            </tr>
            </thead>
            <tbody>

@foreach($students as $student)

<tr>         

                  <td>
                    {{ $student->last_name . ' ' . $student->first_name  }} 
                    <input type="hidden" name="student_ids[]" value="{{$student->id}}">
                  </td>

                    <td>
                        <div class="checkbox">
                          <label>
                            <input type="checkbox" class="donebox" id="boxIsdone-{{$student->id}}" > Absent(e)
                          </label>
                        </div>
                        <input type="hidden" name="is_absent[]" value="0" id="is_absent{{$student->id}}">
                    </td>

                  

                  <td>
                    <input type="text" name="note[]" class="form-control" value=""> 
                  </td>

                  <td>
                    <i class="fa fa-hourglass text-warning" style="font-size: 26px;"></i>
                  </td>


</tr>



@endforeach

              </tbody>
            </table>
        </div>


<div class="col-md-12 mt-3 mb-3">
    <button class="btn btn-success btn-lg btn-block" type="submit">Valider</button>
</div>

</form>





  </div>
  </div>
</div>

<?php } // END if $GetSubject !== null ?>





@elseif(isset($_GET['control_id']))

<?php 

$GetControleContinu = \App\ControleContinu::find(e($_GET['control_id']));

if ($GetControleContinu !== null) {

  $students = \App\User::where('is_student', true)->where('class_id', $GetControleContinu->class_id)->orderBy('last_name', 'asc')->get();

 ?>

<div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
  <div class="card">
  <h5 class="card-header">Évaluations</h5>
  <div class="card-body">

<h4><strong>Classe et Matière:</strong> {{ $GetControleContinu->classe->name }} - {{ $GetControleContinu->subject->name }}</h4>

<h4><strong>Titre:</strong> {{ htmlspecialchars_decode($GetControleContinu->titre) }}</h4>

<h4><strong>Note Sur:</strong> /{{ $GetControleContinu->note_sur }}</h4>

<?php $enTofr1 = DateTime::createFromFormat('Y-m-d', substr($GetControleContinu->date, 0, 10)); ?>

<h4><strong>Date:</strong> {{ $enTofr1->format('d/m/Y') }}</h4>
<div class="clearfix"></div><hr>


@if(auth()->user()->is_teacher == 1)

<form method="POST" action="{{ URL::route('controle_evaluations_update', $GetControleContinu->id) }}" class="form-row">

@csrf 

@endif

      <div class="table-responsive">
          <table class="table table-striped table-bordered first">
            <thead>
            <tr class="text-uppercase">
              <th>Nom et Prénom</th>
              <th>Absent(e)</th>
              <th>Note /{{ $GetControleContinu->note_sur }}</th>
              <th>état</th>
            </tr>
            </thead>
            <tbody>

@foreach($students as $student)

<?php 

$student_evaluations = \App\ControleContinuEvaluations::where('student_id', $student->id)->where('control_id', $GetControleContinu->id)->first();

 ?>

@if($student_evaluations !== null)
<tr>         

                    <td>
                      {{ $student->last_name . ' ' . $student->first_name  }} 
                      <input type="hidden" name="student_ids[]" value="{{$student->id}}">
                    </td>

                    <td>
                      @if($student_evaluations->is_absent == 1)
                        <div class="checkbox">
                          <label>
                            <input type="checkbox" class="donebox" id="boxIsdone-{{$student->id}}" checked="checked"> Absent(e)
                          </label>
                        </div>
                        <input type="hidden" name="is_absent[]" value="1" id="is_absent{{$student->id}}">
                      @else
                        <div class="checkbox">
                          <label>
                            <input type="checkbox" class="donebox" id="boxIsdone-{{$student->id}}"> Absent(e)
                          </label>
                        </div>
                        <input type="hidden" name="is_absent[]" value="0" id="is_absent{{$student->id}}">
                      @endif   
                    </td>

                 

                  <td>
                    <input type="text" name="note[]" class="form-control" value="{{ $student_evaluations->note }}"> 
                  </td>

                  <td>
                    <i class="fa fa-check-circle text-success" style="font-size: 20px;"></i> <?php $enTofr = DateTime::createFromFormat('Y-m-d H:i', substr($student_evaluations->updated_at, 0, 16)); echo $enTofr->format('d/m/Y H:i'); ?>

                  </td>



</tr>
@endif


@endforeach

              </tbody>
            </table>
        </div>


@if(auth()->user()->is_teacher == 1)

<div class="col-md-12 mt-3 mb-3">
    <button class="btn btn-success btn-lg btn-block" type="submit">Valider</button>
</div>

</form>

@endif



  </div>
  </div>
</div>

<?php } // END if $GetControleContinu !== null ?>


@else

<div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
  <div class="card">

@if(auth()->user()->is_teacher == 1)
    <h5 class="card-header">
      <a href="#" class="btn btn-primary mb-1" data-toggle="modal" data-target="#exampleModal"><i class="fa fa-plus"></i> Ajouter </a>
    </h5>
@endif

  <div class="card-body">

@if(auth()->user()->is_teacher == 1)

<!-- Modal -->
<div class="modal fade" id="exampleModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
<div class="modal-dialog modal-lg" role="document">
  <div class="modal-content">
    <div class="modal-header">
      <h5 class="modal-title" id="exampleModalLabel">Ajouter</h5>
      <a href="#" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></a>
    </div>
    <div class="modal-body">

<form method="GET" action="{{ URL::route('enseignant_evaluations_controle') }}" >


<div class="form-row">

<div class="col-md-12 mb-3">
      <label>Matières / Classes</label>
      <select name="subject_id" class="selectpicker" data-width="100%" required="required">   
      <option value="">Choisir</option>
        @foreach($subjects as $subject)

        <?php $getclass = \App\Classes::find($subject->class_id); ?>

          <option value="{{ $subject->id }}">{{ $subject->name }} ({{ $getclass->name }})</option>
        @endforeach
      </select>
  </div>


  <div class="col-md-12 mb-3">
    <label>Titre:</label>
    <div class="form-group">
    <div class="input-group">

    <input name="titre" type="text" class="form-control" required="required" />
    
      <div class="input-group-append">
      <div class="input-group-text"><i class="fa fa-edit"></i></div>
      </div>
    </div>
  </div>
  </div>


  <div class="col-md-12 mb-3">
    <label>Date:</label>
    <div class="form-group">
    <div class="input-group date" id="datetimepickerdate" data-target-input="nearest">

    <input name="date" type="text" class="form-control datetimepicker-input" data-target="#datetimepickerdate" required="required" value="{{ old('date') }}" />
    
      <div class="input-group-append" data-target="#datetimepickerdate" data-toggle="datetimepicker">
      <div class="input-group-text"><i class="far fa-calendar-alt"></i></div>
      </div>
    </div>
  </div>
  </div>

<div class="col-md-12 mb-3">
    <label>Note sur:</label>
    <select name="note_sur" class="selectpicker" data-width="100%" required="required">
    <option value="10">/10</option>
    <option value="20">/20</option>
    <option value="40">/40</option>
    </select>
</div>


 
</div>

<div class="form-row mt-1">
<div class="col-md-12">
    <button class="btn btn-success btn-block" type="submit">Ajouter</button>
</div>
</div>

</form>

    </div>
    <div class="modal-footer">
      <a href="#" class="btn btn-dark" data-dismiss="modal">Fermer</a>
    </div>
  </div>
</div>
</div>
<!-- End Modal -->

@endif

<div class="clearfix"></div>



      <div class="table-responsive">
          <table id="example" class="table table-striped table-bordered first">
            <thead>
            <tr class="text-uppercase">
              <th style="display: none;"></th>
              <th>Classe/Matière</th>
              <th>Titre</th>
              @if(auth()->user()->is_teacher !== 1)
              <th>Enseignant</th>
              @endif
              <th>Date</th>
              <th>Action</th>
            </tr>
            </thead>
            <tbody>

             @foreach($controlesContinu as $controleCont)
                <tr>

                  <td style="display: none;">{{ $controleCont->id }}</td>
                                    
                  <td>
                    <?php $FindSubject = \App\Subjects::find($controleCont->subject_id); ?>
                    {{ $controleCont->classe->name }} @if($FindSubject !== null ) - {{ $FindSubject->name }} @endif
                  </td>

                  <td>
                    {{ htmlspecialchars_decode($controleCont->titre) }}
                  </td>

                  @if(auth()->user()->is_teacher !== 1)

                  <td>{{ $controleCont->teacher->last_name . ' ' . $controleCont->teacher->first_name }}</td>
                  
                  @endif

                  <td>
                    <?php $enTofr1 = DateTime::createFromFormat('Y-m-d', substr($controleCont->date, 0, 10)); echo $enTofr1->format('d/m/Y') ?>
                  </td>
                  


                      <td>

                        <a class="btn btn-success btn-sm" href="{{ URL::route('enseignant_evaluations_controle') }}?control_id={{ $controleCont->id }}"><i class="fa fa-list"></i> Évaluations</a>

@if(auth()->user()->super_admin == 1 OR auth()->user()->is_teacher == 1)
                      
                        <a onclick="return confirm('Supprimer?')" href="{{ URL::route('enseignant_destroy_controle', $controleCont->id) }}" class="btn btn-danger btn-sm"><i class="fa fa-trash"></i>  </a>
@endif                

                      </td>

                    </tr>

                    @endforeach
                  </tbody>
                  </table>
               </div>

    </div>
  </div>
</div>

                                     
@endif

</div><!-- END row -->
                
               

@stop