@extends('layouts.master_panel')

@section('title') Modifier @stop

@section('CSS') 


<link rel="stylesheet" type="text/css" href="{{url('/')}}/js/datatables/dataTables.bootstrap4.min.css">

<link rel="stylesheet" href="{{url('/')}}/assets/vendor/datepicker/tempusdominus-bootstrap-4.css" />

@stop

@section('JS') 


<script src="{{url('/')}}/js/datatables/jquery.dataTables.min.js"></script>
<script src="{{url('/')}}/js/datatables/dataTables.bootstrap4.min.js"></script>

<script type="text/javascript" class="init">
  $(document).ready(function() {
    $("#example").dataTable({ "language": { "url": "{{ url('/') }}/js/datatables/lang/fr.json" }
    });
  });
  </script>

<script src="{{url('/')}}/assets/vendor/datepicker/moment.js"></script>
<script src="{{url('/')}}/assets/vendor/datepicker/tempusdominus-bootstrap-4.js"></script>
<script src="{{url('/')}}/assets/vendor/datepicker/datepicker.js"></script>

<script src="{{url('/')}}/assets/vendor/datepicker/fr.js"></script>

<script type="text/javascript">
    $(function () {
        $('#datetimepickerdate').datetimepicker({
          format: 'D/M/YYYY',
          locale: 'fr'
      });
    });

    $(function () {
        $('#datetimepicker').datetimepicker({
          format: 'H:mm',
          locale: 'fr'
      });
    });


    $('#datetimepicker4').datetimepicker({
        format: 'H:mm',
        locale: 'fr'
    });

</script>



<script type="text/javascript">
      

        $('#myForm').submit(function(event) {

          event.preventDefault();

          $('#resultajax').append('<div class="text-center"><img src="{{ url("/") }}/assets/images/loader.gif" alt="ajouter..." /></div>');

          $('#submit').hide();

          
           $.ajax({
            type: 'POST',
            url: '{{ route("enseignant_horaires") }}',
            data: $(this).serialize(),

            success: function(data) {
                              
                if(data == 'true') {   
                  $('#resultajax').html("<div class='alert alert-success text-center'><strong>Ajouter avec succès</strong></div>");
                  $('#submit').show();
                 }

                if(data == 'false') {
                  $('#resultajax').html("<div class='alert alert-danger text-center'><strong>Une erreur est survenue .. réessayer</strong></div>");
                  $('#submit').show();
                }
                                     
              }

            });
                          
          });

          function refresh() {
            // to current URL
            window.location='{{ URL::current() }}';
          }

</script>


@stop


@section('content')


                  <!-- ============================================================== -->
                  <!-- pageheader  -->
                  <!-- ============================================================== -->
                  <div class="row">
                      <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                          <div class="page-header">
                              <h3 class="mb-2">Modifier </h3>
                           
                              <div class="page-breadcrumb">
                                  <nav aria-label="breadcrumb">
                                      <ol class="breadcrumb">
                                          <li class="breadcrumb-item"><a href="{{ URL::route('admin_index') }}" class="breadcrumb-link">Accueil</a></li>
                                          <li class="breadcrumb-item active" aria-current="page">Enseignants</li>
                                      </ol>
                                  </nav>
                              </div>
                          </div>
                      </div>
                  </div>
                  <!-- ============================================================== -->
                  <!-- end pageheader  -->
                  <!-- ============================================================== -->



<div class="col-md-12">
@if(Session::has('error'))

<div class="alert alert-danger alert-dismissible fade show text-center" role="alert">
  <strong>{{ Session::get('error') }}</strong>
  <button type="button" class="close" data-dismiss="alert" aria-label="Close">
    <span aria-hidden="true">&times;</span>
  </button>
</div>

@endif

@if(Session::has('success'))
<div class="alert alert-success alert-dismissible fade show text-center" role="alert">
  <strong>{{ Session::get('success') }}</strong>
  <button type="button" class="close" data-dismiss="alert" aria-label="Close">
    <span aria-hidden="true">&times;</span>
  </button>
</div>
@endif
</div>

<div class="clearfix"></div>

<div class="row">


   <div class="col-xl-3 col-lg-3 col-md-5 col-sm-12 col-12">
      <div class="card">
        <div class="card-body">
          <div class="user-avatar text-center d-block">
            @if(!empty($enseignant->image))
            <img src="{{ url('/') }}/uploads/images/{{ $enseignant->image }}" alt="" class="rounded-circle user-avatar-xxl">
            @else
            <img src="{{ url('/') }}/uploads/images/user.png" alt="" class="rounded-circle user-avatar-xxl">
            @endif
          </div>
          <div class="text-center">
            <h2 class="font-24 mb-0">{{ $enseignant->last_name }} {{ $enseignant->first_name }}</h2>
          </div>
        </div>
        <div class="card-body border-top">
          <h3 class="font-16">Informations de contact</h3>
          <div class="">
            <ul class="list-unstyled mb-0">
              <li class="mb-2"><i class="fas fa-fw fa-envelope mr-2"></i>{{ $enseignant->email }}</li>
              <li class="mb-0"><i class="fas fa-fw fa-phone mr-2"></i>{{ $enseignant->phone }}</li>
            </ul>
          </div>
        </div>




      </div>
    </div>


<div class="col-xl-9 col-lg-9 col-md-7 col-sm-12 col-12">
  <div class="card">
    <h5 class="card-header">Modifier</h5>
  <div class="card-body">




<form method="POST" action="{{ URL::route('enseignant_update', $enseignant->id) }}"  enctype="multipart/form-data">

{{ csrf_field() }}

<div class="row">

<div class="col-md-12 mb-3">
    <label>Type:</label>
    <select name="teacher_type" class="selectpicker" data-width="100%" required="required">
    @if($enseignant->teacher_type == 1)
      <option value="1" selected="selected">Enseignant permanent</option>
      <option value="2">Enseignant vacataire</option>
      <option value="3">Enseignant stagiaire</option>
      <option value="4">Enseignant contractuel</option>
    @elseif($enseignant->teacher_type == 2)
      <option value="1">Enseignant permanent</option>
      <option value="2" selected="selected">Enseignant vacataire</option>
      <option value="3">Enseignant stagiaire</option>
      <option value="4">Enseignant contractuel</option>
    @elseif($enseignant->teacher_type == 3)
      <option value="1">Enseignant permanent</option>
      <option value="2">Enseignant vacataire</option>
      <option value="3" selected="selected">Enseignant stagiaire</option>
      <option value="4">Enseignant contractuel</option>
    @elseif($enseignant->teacher_type == 4)
      <option value="1">Enseignant permanent</option>
      <option value="2">Enseignant vacataire</option>
      <option value="3">Enseignant stagiaire</option>
      <option value="4" selected="selected">Enseignant contractuel</option>
    @endif
        
    </select>
</div>


 <div class="col-md-12 mb-3">
    <div class="form-group">
    <label>Taux horaire:</label>
    <div class="input-group">
    <div class="input-group-prepend"><span class="input-group-text"><i class="fa fa-info-circle"></i></span></div>
    <input name="taux_horaire" type="text" class="form-control" value="{{ $enseignant->taux_horaire }}">
    </div>
    </div>
  </div>


  <div class="col-md-6">
    <div class="form-group">
    <label>Nom</label>
    <div class="input-group">
    <div class="input-group-prepend"><span class="input-group-text"><i class="fa fa-edit"></i></span></div>
    <input name="last_name" type="text" class="form-control" value="{{ $enseignant->last_name }}" required>
    </div>
    </div>
  </div>

  <div class="col-md-6">
    <div class="form-group">
    <label>Prénom</label>
    <div class="input-group">
    <div class="input-group-prepend"><span class="input-group-text"><i class="fa fa-edit"></i></span></div>
    <input name="first_name" type="text" class="form-control" value="{{ $enseignant->first_name }}" required>
    </div>
    </div>
  </div>

</div>


<div class="row">

  <div class="col-md-6">
    <div class="form-group">
    <label>Téléphone</label>
    <div class="input-group">
    <div class="input-group-prepend"><span class="input-group-text"><i class="fa fa-phone"></i></span></div>
    <input name="phone" type="text" class="form-control" value="{{ $enseignant->phone }}">
    </div>
    </div>
  </div>

  <div class="col-md-6">
    <div class="form-group">
    <label>Email</label>
    <div class="input-group">
    <div class="input-group-prepend"><span class="input-group-text"><i class="fa fa-envelope"></i></span></div>
    <input name="email" type="email" class="form-control" value="{{ $enseignant->email }}">
    </div>
    </div>
    @if($errors->first('email'))
      <small class="form-text text-danger">{{ $errors->first('email') }}</small>
    @endif
  </div>

</div>



<div class="row">
  <div class="col-md-12">
      <label>Image</label>
        <div class="custom-file">
          <input type="file" name="image">
          
        </div>
        @if($errors->first('image'))
          <small class="form-text text-danger">{{ $errors->first('image') }}</small>
        @endif
    </div>
</div>

<div class="row">
<div class="col-md-12 mt-3">
    <button class="btn btn-primary" type="submit">Modifier</button>
</div>
</div>

</form>

<div class="clearfix"></div><hr>


<form method="POST" action="{{ URL::route('enseignant_password_update', $enseignant->id) }}" >

{{ csrf_field() }}

<div class="row">

  <div class="col-md-12">
    <h5 class="text-danger">le mot de passe actuel: {{ $enseignant->mptxt }}</h5>
  </div>

  <div class="col-md-6">
    <div class="form-group">
    <label>Nom d'utilisateur</label>
    <div class="input-group">
    <div class="input-group-prepend"><span class="input-group-text">@</span></div>
    <input name="username" type="text" class="form-control" value="{{ $enseignant->username }}">
    </div>
    </div>
    @if($errors->first('username'))
      <small class="form-text text-danger">{{ $errors->first('username') }}</small>
    @endif
  </div>

  <div class="col-md-6">
    <div class="form-group">
    <label>Mot de passe</label>
    <div class="input-group">
    <div class="input-group-prepend"><span class="input-group-text" style="cursor: pointer; " onclick="generatePassword();">Générer mot de passe</span></div>
    <input name="password" type="text" id="inputPassword" class="form-control input-lg" required="required">
    </div>
    </div>
  </div>

</div>


<script type="text/javascript">

function generatePassword() {
    var length = 8,
        charset = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789!@#$%&*",
        retVal = "";
    for (var i = 0, n = charset.length; i < length; ++i) {
        retVal += charset.charAt(Math.floor(Math.random() * n));
    }

  //  return retVal;
    $('#inputPassword').val(retVal); 
}

</script> 

<div class="row">
<div class="col-md-12">
    <button class="btn btn-primary" type="submit">Modifier</button>
</div>
</div>

</form><!-- End form -->

</div>
</div>
</div>

<div class="clearfix"></div> 






</div><!-- END row -->
                






               

@stop