@extends('layouts.master_panel')

@section('title') Enseignants suspendus @stop

@section('CSS') 


<link rel="stylesheet" type="text/css" href="{{url('/')}}/js/datatables/dataTables.bootstrap4.min.css">

@stop

@section('JS') 


<script src="{{url('/')}}/js/datatables/jquery.dataTables.min.js"></script>
<script src="{{url('/')}}/js/datatables/dataTables.bootstrap4.min.js"></script>

<script type="text/javascript" class="init">
  $(document).ready(function() {
    $("#example").dataTable({ "language": { "url": "{{ url('/') }}/js/datatables/lang/fr.json" }
    });
  });
  </script>




@stop


@section('content')


                  <!-- ============================================================== -->
                  <!-- pageheader  -->
                  <!-- ============================================================== -->
                  <div class="row">
                      <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                          <div class="page-header">
                              <h3 class="mb-2">Enseignants suspendus</h3>
                           
                              <div class="page-breadcrumb">
                                  <nav aria-label="breadcrumb">
                                      <ol class="breadcrumb">
                                          <li class="breadcrumb-item"><a href="{{ URL::route('admin_index') }}" class="breadcrumb-link">Accueil</a></li>
                                          <li class="breadcrumb-item active" aria-current="page">Enseignants suspendus</li>
                                      </ol>
                                  </nav>
                              </div>
                          </div>
                      </div>
                  </div>
                  <!-- ============================================================== -->
                  <!-- end pageheader  -->
                  <!-- ============================================================== -->


<div class="row">


<div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
  <div class="card">
  <div class="card-body">


<div class="clearfix"></div>

@if(Session::has('error'))

<div class="alert alert-danger alert-dismissible fade show text-center" role="alert">
  <strong>{{ Session::get('error') }}</strong>
  <button type="button" class="close" data-dismiss="alert" aria-label="Close">
    <span aria-hidden="true">&times;</span>
  </button>
</div>

@endif

@if(Session::has('success'))
<div class="alert alert-success alert-dismissible fade show text-center" role="alert">
  <strong>{{ Session::get('success') }}</strong>
  <button type="button" class="close" data-dismiss="alert" aria-label="Close">
    <span aria-hidden="true">&times;</span>
  </button>
</div>
@endif

<div class="clearfix"></div>

      <div class="table-responsive">
          <table id="example" class="table table-striped table-bordered first">
            <thead>
            <tr class="text-uppercase">
              <th>#</th>
              <th>Nom et Prénom</th>
              <th>Type</th>
              <th>Téléphone</th>
              <th>Email</th>
              <th>Ressources</th>
              @if(auth()->user()->super_admin == 1)
              <th>Action</th>
              @endif
            </tr>
            </thead>
            <tbody>

<?php 

function formatSizeUnits($bytes) {

        if ($bytes >= 1073741824)
        {
            $bytes = number_format($bytes / 1073741824, 2) . ' GB';
        }
        elseif ($bytes >= 1048576)
        {
            $bytes = number_format($bytes / 1048576, 2) . ' MB';
        }
        elseif ($bytes >= 1024)
        {
            $bytes = number_format($bytes / 1024, 2) . ' KB';
        }
        elseif ($bytes > 1)
        {
            $bytes = $bytes . ' bytes';
        }
        elseif ($bytes == 1)
        {
            $bytes = $bytes . ' byte';
        }
        else
        {
            $bytes = '0 bytes';
        }

        return $bytes;
}

?>
             @foreach($enseignants as $enseignant)

@if($enseignant->is_teacher == 1)
<tr style="font-size: 0.9em;">
@else
<tr style="font-size: 0.9em; background-color: #ed9a89; color: #313538;">
@endif                                                
                  <td>
                    @if(!empty($enseignant->image))
                    <img style="max-width: 65px; max-height: 65px;" src="{{ url('/') }}/uploads/images/{{ $enseignant->image }}" alt="" class="rounded-circle user-avatar-xxl">
                    @else
                    <img style="max-width: 65px; max-height: 65px;" src="{{ url('/') }}/uploads/images/user.png" alt="" class="rounded-circle user-avatar-xxl">
                    @endif
                  </td>

                  <td>{{ $enseignant->last_name . ' ' . $enseignant->first_name }}</td>

                  

                  <td>
                    @if($enseignant->teacher_type == 1) Permanent
                    @elseif($enseignant->teacher_type == 2) Vacataire
                    @elseif($enseignant->teacher_type == 3) Stagiaire
                    @elseif($enseignant->teacher_type == 4) Contractuel @endif
                  </td>

                  <td>{{ $enseignant->phone }}</td>
                  <td>{{ $enseignant->email }}</td>

                  <td>

                    <strong>{{ count($enseignant->dossiers) }}</strong> dossiers | <strong>{{ count($enseignant->ressources) }}</strong> ressources | 

                    <?php $total_size = 0; ?>

                    @foreach($enseignant->ressources as $ressourc)

                    <?php $total_size = $total_size + $ressourc->file_size; ?>

                    @endforeach

                    {{ formatSizeUnits($total_size) }}

                  </td>

       
@if(auth()->user()->super_admin == 1)
                      <td>


                        <a href="{{ URL::route('enseignant_edit', $enseignant->id) }}" class="btn btn-success btn-sm mb-1"><i class="fa fa-edit"></i> Modifier </a>

                        @if($enseignant->is_teacher == 1)

                        <a onclick="return confirm('Suspendre le compte?')" href="{{ URL::route('disable_teacher', $enseignant->id) }}" class="btn btn-brand btn-sm mb-1"><i class="fa fa-address-card"></i> Suspendre le compte </a>

                        @else

                        <a onclick="return confirm('Activer le compte?')" href="{{ URL::route('active_teacher', $enseignant->id) }}" class="btn btn-brand btn-sm mb-1"><i class="fa fa-address-card"></i> Activer le compte </a>

                        @endif

                        <a onclick="return confirm('Supprimer?')" href="{{ URL::route('enseignant_destroy', $enseignant->id) }}" class="btn btn-danger btn-sm mb-1"><i class="fa fa-trash"></i></a>

                      </td>
@endif

                    </tr>

                    @endforeach
                  </tbody>
                  </table>
               </div>

    </div>
  </div>
</div>

                          
</div><!-- END row -->
                
               

@stop