@extends('layouts.master_panel')

@section('title') Pointage @stop

@section('CSS') 


<link rel="stylesheet" type="text/css" href="{{url('/')}}/js/datatables/dataTables.bootstrap4.min.css">

@stop

@section('JS') 


<script src="{{url('/')}}/js/datatables/jquery.dataTables.min.js"></script>
<script src="{{url('/')}}/js/datatables/dataTables.bootstrap4.min.js"></script>

<script type="text/javascript" class="init">
  $(document).ready(function() {
    $("#example").dataTable({ 
      "language": { "url": "{{ url('/') }}/js/datatables/lang/fr.json" },
      "order": [[ 0, "desc" ]]
    });
  });

  </script>

<script src="{{url('/')}}/assets/vendor/datepicker/moment.js"></script>
<script src="{{url('/')}}/assets/vendor/datepicker/tempusdominus-bootstrap-4.js"></script>
<script src="{{url('/')}}/assets/vendor/datepicker/datepicker.js"></script>

<script src="{{url('/')}}/assets/vendor/datepicker/fr.js"></script>

<script type="text/javascript">
    $(function () {
        $('#datetimepickerdate').datetimepicker({
          format: 'DD/M/YYYY',
          locale: 'fr'
      });
    });

    $(function () {
        $('#datetimepickerdate2').datetimepicker({
          format: 'DD/M/YYYY',
          locale: 'fr'
      });
    });

</script>


<script type="text/javascript">
document.getElementById('mybutton').addEventListener('click', function(){
  window.open('{{ URL::route('pointage_historique_print') }}', 'result', 'width=980,height=720');
  document.getElementById('myform').submit();
});
</script>

@stop


@section('content')


                  <!-- ============================================================== -->
                  <!-- pageheader  -->
                  <!-- ============================================================== -->
                  <div class="row">
                      <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                          <div class="page-header">
                              <h3 class="mb-2">Pointage</h3>
                           
                              <div class="page-breadcrumb">
                                  <nav aria-label="breadcrumb">
                                      <ol class="breadcrumb">
                                          <li class="breadcrumb-item"><a href="{{ URL::route('admin_index') }}" class="breadcrumb-link">Accueil</a></li>
                                          <li class="breadcrumb-item active" aria-current="page">Pointage</li>
                                      </ol>
                                  </nav>
                              </div>
                          </div>
                      </div>
                  </div>
                  <!-- ============================================================== -->
                  <!-- end pageheader  -->
                  <!-- ============================================================== -->


<div class="row">

<div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
  <div class="card">
  <h5 class="card-header">
      <a onclick="return confirm('Supprimer?')" href="{{ URL::route('pointage_delete_delete_all') }}" class="btn btn-danger mb-1"><i class="fa fa-trash"></i> Supprimer l'historique</a>

      <a href="#" class="btn btn-primary ml-1 mb-1" data-toggle="modal" data-target="#exampleModal2"><i class="fas fa-history "></i> Historique</a>

      <br>

      <a onclick="window.open('{{ URL::route('badges') }}', 'newwindow', 'width=900,height=700'); return false;" href="{{ URL::route('badges') }}" class="btn btn-primary ml-1 mb-1"><i class="fas fa-qrcode"></i> Générer les badges - enseignants </a>

      <a onclick="window.open('{{ URL::route('students_badges') }}', 'newwindow', 'width=900,height=700'); return false;" href="{{ URL::route('students_badges') }}" class="btn btn-primary ml-1 mb-1"><i class="fas fa-qrcode"></i> Générer les badges - élèves </a>

      <a onclick="window.open('{{ URL::route('personnel_badges') }}', 'newwindow', 'width=900,height=700'); return false;" href="{{ URL::route('personnel_badges') }}" class="btn btn-primary ml-1 mb-1"><i class="fas fa-qrcode"></i> Générer les badges - personnel </a>

     

    </h5>
  <div class="card-body">


<!-- Modal -->
<div class="modal fade" id="exampleModal2" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel2" aria-hidden="true">
<div class="modal-dialog" role="document">
  <div class="modal-content">
    <div class="modal-header">
      <h5 class="modal-title" id="exampleModalLabel2">Historique</h5>
      <a href="#" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></a>
    </div>
    <div class="modal-body">

<form method="GET" target="result" id="myform" action="{{ URL::route('pointage_historique_print') }}" class="row">


<div class="col-md-12 mb-2">
    <label>du:</label>
    <div class="form-group">
    <div class="input-group date" id="datetimepickerdate" data-target-input="nearest">

    <input name="from" type="text" class="form-control datetimepicker-input" data-target="#datetimepickerdate" />
    
      <div class="input-group-append" data-target="#datetimepickerdate" data-toggle="datetimepicker">
      <div class="input-group-text"><i class="far fa-calendar-alt"></i></div>
      </div>
    </div>
  </div>
</div>

<div class="col-md-12 mb-2">
    <label>au:</label>
    <div class="form-group">
    <div class="input-group date" id="datetimepickerdate2" data-target-input="nearest">

    <input name="to" type="text" class="form-control datetimepicker-input" data-target="#datetimepickerdate2" />
    
      <div class="input-group-append" data-target="#datetimepickerdate2" data-toggle="datetimepicker">
      <div class="input-group-text"><i class="far fa-calendar-alt"></i></div>
      </div>
    </div>
  </div>
</div>


<div class="col-md-12 mb-3">
    <button id="mybutton" class="btn btn-success btn-block" type="submit">Historique</button>
</div>



</form>



    </div>

    <div class="modal-footer">
      <a href="#" class="btn btn-dark" data-dismiss="modal">Fermer</a>
    </div>

  </div>
</div>
</div>
<!-- End Modal -->

@if(Session::has('error'))

<div class="alert alert-danger alert-dismissible fade show text-center" role="alert">
  <strong>{{ Session::get('error') }}</strong>
  <button type="button" class="close" data-dismiss="alert" aria-label="Close">
    <span aria-hidden="true">&times;</span>
  </button>
</div>

@endif

@if(Session::has('success'))
<div class="alert alert-success alert-dismissible fade show text-center" role="alert">
  <strong>{{ Session::get('success') }}</strong>
  <button type="button" class="close" data-dismiss="alert" aria-label="Close">
    <span aria-hidden="true">&times;</span>
  </button>
</div>
@endif

<div class="clearfix"></div>


      <div class="table-responsive">
          <table id="example" class="table table-striped table-bordered first">
            <thead>
            <tr class="text-uppercase">
              <th style="display: none;"></th>
              <th>#</th>
              <th>Nom et Prénom</th>
              <th>Type</th>
              <th>Pointage</th>
              <th>Retard</th>
              <th>Action</th>
            </tr>
            </thead>
            <tbody>

             @foreach($historique as $histor)
                <tr>

                  <td style="display: none;">{{ $histor->id }}</td>
     

@if(!empty($histor->student_id))
<td>  <span class="badge badge-info"><i class="fa fa-user"></i> Elève</span> </td>
<td> {{ $histor->student->last_name . ' ' . $histor->student->first_name }} </td>
@endif

@if(!empty($histor->personnel_id))
<td>  <span class="badge badge-info"><i class="fa fa-user"></i> Personnel</span> </td>
<td>  {{ $histor->personnel->last_name . ' ' . $histor->personnel->first_name }} </td>
@endif

@if(!empty($histor->teacher_id))
<td>  <span class="badge badge-info"><i class="fa fa-user"></i> Enseignant</span> </td>
<td>  {{ $histor->teacher->last_name . ' ' . $histor->teacher->first_name }} </td>
@endif


                  <td>
                    @if($histor->type == 1)
                      <span class="badge badge-success">Entrée</span>
                    @else
                      <span class="badge badge-danger">Sortie</span>
                    @endif
                  </td>

                  <td>
                    <?php $enTofr = DateTime::createFromFormat('Y-m-d H:i', substr($histor->created_at, 0, 16)); ?>

                      {{ $enTofr->format('d/m/Y H:i') }}
                  </td>

                  <td>
                    @if($histor->late_minutes > 0)
                      {{ $histor->late_minutes }} Minutes
                    @else - @endif
                  </td>

                
                  <td>
                    <a onclick="return confirm('Supprimer?')" href="{{ URL::route('pointage_delete', $histor->id) }}" class="btn btn-danger btn-sm"><i class="fa fa-trash"></i></a>
                  </td>

                </tr>

              @endforeach
            </tbody>
          </table>
        </div>


    </div>
  </div>
</div>

                          
</div><!-- END row -->
                
               

@stop